/*---------------------------------------------*\
|  Servo Driver					|
|  Contains functions used to drive ATMega328	|
|  Servo Driver and Arduino Vex Robot Controller|
\*---------------------------------------------*/

#include <stdio.h>
#include <iostream>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <string>

using namespace std;

class Servo_driver
{
public:
  Servo_driver();
  Servo_driver(string dev);

  void serialOpen(string dev);

  void set_motors(char m1, char m2);
  void set_motors();

  void set_speed_limit(char m1l, char m2l);
  void set_speed_limit();

  void set_motor1_speed(char m1);
  void set_motor2_speed(char m2);
  void set_motor1_limit(char m1l);
  void set_motor2_limit(char m2l);

  char get_motor1_speed();
  char get_motor2_speed();
  char get_motor1_limit();
  char get_motor2_limit();

private:
  int portfd;
  char motor1_speed;
  char motor2_speed;
  char motor1_limit;
  char motor2_limit;
};
